# Ethnic fractionalization
# Script based on code by Jay Ulfelder, 2014-01-20
# Source-URL: https://github.com/ulfelder/cpg-statrisk-2014/blob/master/elf.R
# Data-Source: Fearon / Laitin (2003), http://www.stanford.edu/group/ethnic/publicdata/publicdata.html

ethnic <- read.dta("Daten/Replication Fearon Laitin 2003/egroupsrepdata.dta")

ef <- tapply(ethnic$ef, ethnic$country, max)
elf <- tapply(ethnic$elf, ethnic$country, max)

melt.ef <- melt(ef)
melt.elf <- melt(elf)

names(melt.ef) <- c("country", "ef")
names(melt.elf) <- c("country", "elf")

eth <- merge(melt.ef, melt.elf)

# Correct country names and wrong codes
eth$country <- as.character(eth$country)
eth$country[eth$country=="COSTARICA"] <- "COSTA RICA"
eth$country[eth$country=="GERMAN DEM. REP."] <- "GERMAN DEMOCRATIC REPUBLIC"
eth$country[eth$country=="PAPUA N.G."] <- "PAPUA NEW GUINEA"
eth$country[eth$country=="N. KOREA"] <- "KOREA, DEMOCRATIC REPUBLIC OF"
eth$country[eth$country=="S. KOREA"] <- "KOREA, REPUBLIC OF"
eth <- subset(eth, subset = eth$country != "USSR" & eth$country != "YUGOSLAV")

eth$actorid <- countrycode(eth$country, "country.name", "cown", warn = T)
eth$actorid[eth$country=="CZECHOSLOVAKIA"] <- 315
eth$actorid[eth$country=="DEM. REP. CONGO"] <- 490

eth <- subset(eth, select=c("actorid", "ef", "elf"))

# Fill in missing values from EPR where possible
#pks <- c(770, 0.69, NA) # From EPR # PAKISTAN
ypr <- c(680, 0, NA) # From EPR # SOUTH YEMEN
yar <- c(678, 0.42, NA) # From EPR # NORTH YEMEN
kos <- c(347, eth$ef[eth$actorid==345], eth$elf[eth$actorid==345]) # KOSOVO
#srb <- c("SRB", eth$ef[eth$sftgcode=="YGS"], eth$elf[eth$sftgcode=="YGS"])
#mne <- c("MNE", eth$ef[eth$sftgcode=="YGS"], eth$elf[eth$sftgcode=="YGS"])
com <- c(581, NA, NA) # COMOROS
rvn <- c(817, 0.39, NA) # From EPR # REPUBLIC OF VIETNAM
#drv <- c(816, 0.39, NA) # Using EPR's value for RVN # DEMOCRATIC REPUBLIC OF VIETNAM
#eqg <- c("EQG", NA, NA)
#etm <- c("ETM", NA, NA)
#ger <- c("GER", eth$ef[eth$sftgcode=="GFR"], eth$elf[eth$sftgcode=="GFR"])
#qat <- c("QAT", NA, NA)
#sol <- c("SOL", NA, NA)
ssd <- c(626, eth$ef[eth$actorid==625], eth$elf[eth$actorid==625]) # SOUTH SUDAN
eth <- as.data.frame(rbind(eth, ypr, yar, kos, com, rvn, ssd))

# Fix types
eth$ef <- as.numeric(eth$ef)
eth$elf <- as.numeric(eth$elf)

#write.csv(rack, "c:/users/jay/documents/ushmm/statrisk2014/outdata/elf.csv", row.names = FALSE)

Master <- join(Master, eth, by = c("actorid"), type = "left", match = "all")
rm(eth, ethnic, melt.ef, melt.elf)
rm(ef, elf, ypr, yar, kos, com, rvn, ssd)
